# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: C

def serene_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Start with cooperation to build trust
    
    # Analyze opponent's code for patterns
    is_mirror = "mirror" in opponent_program_code or "opp_history[-1]" in opponent_program_code
    is_alternator = "alternator" in opponent_program_code or "len(my_history) % 2" in opponent_program_code
    is_random = "random.random()" in opponent_program_code
    
    # Late-game strategy (last 2 rounds)
    total_rounds = 10
    current_round = len(my_history) + 1
    if current_round >= total_rounds - 1:
        if current_round == total_rounds:
            return "D"  # Defect in the last round
        # Penultimate round: cooperate unless opponent defected recently
        if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
            return "D"
        return "C"
    
    # Mid-game adaptation
    if is_mirror or is_alternator:
        if random.random() < 0.1:  # Introduce slight unpredictability
            return "D"
        # Alternate to confuse mirroring/alternating opponents
        return "D" if my_history[-1] == "C" else "C"
    
    if is_random:
        # Tit-for-tat with forgiveness
        if opp_history[-1] == "D":
            return "D"  # Retaliate
        return "C"
    
    # Default behavior: cooperate unless provoked
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"  # Punish defection streaks
    return "C"